/*
 * Decompiled with CFR 0.152.
 */
package com.aimedia.autocat;

import com.aimedia.autocat.AutoCategorizer;
import com.aimedia.autocat.config.Config;
import com.aimedia.autocat.config.ConfigUI;
import java.util.Date;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.ui.config.ConfigSection;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;

public class AutoCatPlugin
implements Plugin {
    private static AutoCatPlugin instance = null;
    private PluginInterface pluginInterface;
    private LoggerChannel log;
    private Config config;
    public static final String NAME = "autocat";

    public static AutoCatPlugin getPlugin() {
        return instance;
    }

    public void initialize(PluginInterface pluginInterface) throws PluginException {
        instance = this;
        this.pluginInterface = pluginInterface;
        this.log = pluginInterface.getLogger().getChannel(NAME);
        final BasicPluginViewModel view = pluginInterface.getUIManager().createBasicPluginViewModel(pluginInterface.getUtilities().getLocaleUtilities().getLocalisedMessageText("autocat.name"));
        view.getActivity().setVisible(false);
        view.getProgress().setVisible(false);
        view.getStatus().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String content) {
                view.getLogArea().appendText("[" + new Date().toString() + "] " + content + "\n");
            }

            public void messageLogged(String str, Throwable error) {
                view.getLogArea().appendText("[" + new Date().toString() + "] " + str + "\n");
                view.getLogArea().appendText(error.getLocalizedMessage() + "\n");
            }
        });
        this.config = new Config(pluginInterface);
        ConfigUI cfg = new ConfigUI(this.config);
        pluginInterface.addConfigSection((ConfigSection)cfg);
        AutoCategorizer categorizer = new AutoCategorizer(this.config);
    }

    public final LoggerChannel getLog() {
        return this.log;
    }

    public final PluginInterface getPluginInterface() {
        return this.pluginInterface;
    }

    public final LocaleUtilities getLocale() {
        return this.pluginInterface.getUtilities().getLocaleUtilities();
    }
}

