/*
 * Decompiled with CFR 0.152.
 */
package com.aimedia.autocat;

import com.aimedia.autocat.AutoCatPlugin;
import com.aimedia.autocat.config.Config;
import com.aimedia.autocat2.matching.IRuleSetListener;
import com.aimedia.autocat2.matching.OrderedRuleSet;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;

public class AutoCategorizer
implements IRuleSetListener,
DownloadManagerListener {
    private final transient DownloadManager dlm;
    private final transient LoggerChannel log;
    private final transient LocaleUtilities locale;
    private Config config;

    public AutoCategorizer(Config config) {
        this.config = config;
        if (config == null) {
            throw new IllegalArgumentException("Null rulesets are not permitted");
        }
        this.dlm = AutoCatPlugin.getPlugin().getPluginInterface().getDownloadManager();
        this.log = AutoCatPlugin.getPlugin().getLog();
        this.locale = AutoCatPlugin.getPlugin().getPluginInterface().getUtilities().getLocaleUtilities();
        config.getRules().addRuleSetListener(this);
        this.dlm.addListener((DownloadManagerListener)this);
    }

    public void ruleSetUpdated(OrderedRuleSet rules) {
        Download[] dls = this.dlm.getDownloads();
        for (int i = 0; i < dls.length; ++i) {
            this.match(dls[i]);
        }
    }

    public void downloadAdded(Download download) {
        download.addListener(new DownloadListener(){

            public void stateChanged(Download download, int old_state, int new_state) {
                if (old_state == 3 && (new_state == 4 || new_state == 5)) {
                    AutoCategorizer.this.match(download);
                }
            }

            public void positionChanged(Download download, int oldPosition, int newPosition) {
            }
        });
    }

    public void downloadRemoved(Download download) {
    }

    private void match(Download download) {
        Torrent torrent = download.getTorrent();
        String categoryName = download.getCategoryName();
        if (!"Categories.uncategorized".equals(categoryName) && !this.config.isModifyExistingCategories()) {
            return;
        }
        String cat = this.config.getRules().match(torrent);
        if (cat != null) {
            download.setCategory(cat);
            this.log.log(1, this.locale.getLocalisedMessageText("autocat.matcher.matched", new String[]{cat, torrent.getName()}));
        }
    }
}

