/*
 * Decompiled with CFR 0.152.
 */
package com.aimedia.autocat.config;

import com.aimedia.autocat.AutoCatPlugin;
import com.aimedia.autocat2.matching.AdvancedRuleSet;
import com.aimedia.autocat2.matching.OrderedRuleSet;
import java.io.File;
import java.io.IOException;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.ui.config.ConfigSection;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;

public class Config
implements ConfigSection {
    private static final String MATCHER_CONFIG_FILE = "autocat_rules.properties";
    private static final String OBSOLETE_MATCHER_CONFIG_FILE = "autocat.config";
    private final AdvancedRuleSet rules;
    private boolean enabled;
    private boolean modifyExistingCategories;
    private PluginInterface pi;
    private LoggerChannel log;
    private LocaleUtilities locale;

    public Config(PluginInterface pluginInterface) {
        this.pi = pluginInterface;
        this.log = AutoCatPlugin.getPlugin().getLog();
        this.locale = this.pi.getUtilities().getLocaleUtilities();
        this.log.log(1, this.locale.getLocalisedMessageText("autocat.info.populating"));
        this.rules = new AdvancedRuleSet();
        File propertyFile = FileUtil.getUserFile((String)MATCHER_CONFIG_FILE);
        if (!propertyFile.exists()) {
            File mapFile = FileUtil.getUserFile((String)OBSOLETE_MATCHER_CONFIG_FILE);
            if (mapFile.exists()) {
                AdvancedRuleSet.transferSettings(mapFile, propertyFile);
            } else {
                try {
                    propertyFile.createNewFile();
                }
                catch (IOException e) {
                    AutoCatPlugin.getPlugin().getLog().log("Unable to create a new configuration file", (Throwable)e);
                }
            }
            this.rules.load(propertyFile);
        } else {
            this.rules.load(propertyFile);
        }
        this.enabled = this.pi.getPluginconfig().getPluginBooleanParameter("enabled", false);
        this.modifyExistingCategories = this.pi.getPluginconfig().getPluginBooleanParameter("modifyExistingCategories", true);
    }

    public String configSectionGetParentSection() {
        return "plugins";
    }

    public String configSectionGetName() {
        this.log.log("configSectionGetName() start/end");
        return "autocat";
    }

    public void configSectionSave() {
        this.log.log("configSectionSave() start");
        try {
            File saveFile = FileUtil.getUserFile((String)MATCHER_CONFIG_FILE);
            if (!saveFile.exists() && !saveFile.createNewFile()) {
                this.log.log(this.locale.getLocalisedMessageText("autocat.err.failRuleCreate"));
            }
            if (!this.rules.save(FileUtil.getUserFile((String)MATCHER_CONFIG_FILE))) {
                this.log.log(this.locale.getLocalisedMessageText("autocat.err.failRuleWrite"));
            }
        }
        catch (IOException e) {
            this.log.log((Throwable)e);
            this.log.log("autocat.err.IO");
        }
        PluginConfig cfg = this.pi.getPluginconfig();
        cfg.setPluginParameter("enabled", this.enabled);
        cfg.setPluginParameter("modifyExistingCategories", this.modifyExistingCategories);
        try {
            cfg.save();
            this.log.log("configSectionSave() clean exit");
        }
        catch (PluginException e1) {
            this.log.log((Throwable)e1);
            this.log.log("configSectionSave() dirty exit");
        }
    }

    public void configSectionDelete() {
        this.log.log(1, this.locale.getLocalisedMessageText("autocat.info.configDelete"));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enablement) {
        if (this.enabled != enablement) {
            this.enabled = enablement;
        }
    }

    public OrderedRuleSet getRules() {
        return this.rules;
    }

    public boolean isModifyExistingCategories() {
        return this.modifyExistingCategories;
    }

    public void setModifyExistingCategories(boolean modifyExistingCategories) {
        if (this.modifyExistingCategories != modifyExistingCategories) {
            this.modifyExistingCategories = modifyExistingCategories;
        }
    }
}

