/*
 * Decompiled with CFR 0.152.
 */
package com.aimedia.autocat.config;

import com.aimedia.autocat.AutoCatPlugin;
import com.aimedia.autocat.config.Config;
import com.aimedia.autocat2.matching.AdvancedRuleSet;
import com.aimedia.autocat2.matching.IRuleSetListener;
import com.aimedia.autocat2.matching.OrderedRuleSet;
import com.aimedia.autocat2.matching.TorrentFieldType;
import com.aimedia.autocat2.matching.TorrentMatcher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.ui.config.ConfigSectionSWT;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;

public class ConfigUI
implements ConfigSectionSWT,
IRuleSetListener {
    private Label lblEnabled = null;
    private Label lblField = null;
    private Button chkEnabled = null;
    private Table tblRules = null;
    private Label lblTrigger = null;
    private Text txtTrigger = null;
    private Button btnAdd = null;
    private Button btnDel = null;
    private Label lblCategory = null;
    private Combo cmbCategory = null;
    private Combo cmbField = null;
    private final PluginInterface pi = AutoCatPlugin.getPlugin().getPluginInterface();
    private final LoggerChannel log = AutoCatPlugin.getPlugin().getLog();
    private final LocaleUtilities locale = this.pi.getUtilities().getLocaleUtilities();
    private Map typeMap;
    private Config config;
    private Label lblModExisting;
    private Button chkModExisting;

    public ConfigUI(Config config) {
        this.log.log(1, this.locale.getLocalisedMessageText("autocat.info.populating"));
        this.config = config;
    }

    public Composite configSectionCreate(Composite parent) {
        this.config.getRules().addRuleSetListener(this);
        Composite panel = new Composite(parent, 0);
        GridData gridData5 = new GridData();
        GridData gridData4 = new GridData();
        GridData gridData1 = new GridData();
        GridData gridData3 = new GridData();
        GridData gridData2 = new GridData();
        GridLayout gridLayout1 = new GridLayout();
        this.lblEnabled = new Label(panel, 0);
        this.chkEnabled = new Button(panel, 32);
        this.lblModExisting = new Label(panel, 0);
        this.chkModExisting = new Button(panel, 32);
        this.createTable(panel);
        this.lblTrigger = new Label(panel, 0);
        this.txtTrigger = new Text(panel, 2048);
        this.lblCategory = new Label(panel, 0);
        this.createCategoryCombo(panel);
        this.lblField = new Label(panel, 0);
        this.createFieldCombo(panel);
        this.createControlPanel(panel);
        gridData3.horizontalSpan = 4;
        gridData3.horizontalAlignment = 1;
        gridData3.verticalAlignment = 2;
        gridData3.grabExcessHorizontalSpace = true;
        this.chkEnabled.setLayoutData((Object)gridData3);
        gridData2.horizontalSpan = 4;
        gridData2.horizontalAlignment = 1;
        gridData2.verticalAlignment = 2;
        gridData2.grabExcessHorizontalSpace = true;
        this.chkModExisting.setLayoutData((Object)gridData2);
        gridData4.grabExcessHorizontalSpace = false;
        gridData4.horizontalSpan = 2;
        gridData1.grabExcessHorizontalSpace = false;
        gridData1.horizontalSpan = 2;
        this.lblEnabled.setLayoutData((Object)gridData4);
        this.lblModExisting.setLayoutData((Object)gridData1);
        this.lblTrigger.setText(this.locale.getLocalisedMessageText("autocat.trigger"));
        this.lblTrigger.setToolTipText(this.locale.getLocalisedMessageText("autocat.trigger.tooltip"));
        gridData5.horizontalSpan = 5;
        gridData5.horizontalAlignment = 4;
        gridData5.verticalAlignment = 2;
        this.txtTrigger.setLayoutData((Object)gridData5);
        this.txtTrigger.setToolTipText(this.locale.getLocalisedMessageText("autocat.trigger.tooltip"));
        this.txtTrigger.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = true;
            }
        });
        this.lblCategory.setText("Category");
        this.lblEnabled.setText(this.locale.getLocalisedMessageText("autocat.enabled"));
        this.chkEnabled.setToolTipText(this.locale.getLocalisedMessageText("autocat.enabled.tooltip"));
        this.lblModExisting.setText(this.locale.getLocalisedMessageText("autocat.modify_existing"));
        this.chkModExisting.setToolTipText(this.locale.getLocalisedMessageText("autocat.modify_existing.tooltip"));
        panel.setLayout((Layout)gridLayout1);
        gridLayout1.numColumns = 6;
        this.lblField.setText(this.locale.getLocalisedMessageText("autocat.config.field"));
        panel.setSize(new Point(635, 456));
        this.chkEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                boolean enablement = b.getSelection();
                ConfigUI.this.config.setEnabled(enablement);
                ConfigUI.this.chkModExisting.setEnabled(enablement);
                ConfigUI.this.txtTrigger.setEnabled(enablement);
                ConfigUI.this.cmbCategory.setEnabled(enablement);
                ConfigUI.this.tblRules.setEnabled(enablement);
                ConfigUI.this.btnAdd.setEnabled(enablement);
                ConfigUI.this.btnDel.setEnabled(enablement);
                if (b.getSelection()) {
                    ConfigUI.this.log.log(ConfigUI.this.locale.getLocalisedMessageText("autocat.logenabled"));
                } else {
                    ConfigUI.this.log.log(ConfigUI.this.locale.getLocalisedMessageText("autocat.logdisabled"));
                }
            }
        });
        this.chkModExisting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                ConfigUI.this.config.setModifyExistingCategories(b.getSelection());
            }
        });
        boolean enablement = this.config.isEnabled();
        this.chkEnabled.setSelection(enablement);
        this.chkModExisting.setEnabled(enablement);
        this.chkModExisting.setSelection(this.config.isModifyExistingCategories());
        this.txtTrigger.setEnabled(enablement);
        this.cmbCategory.setEnabled(enablement);
        this.tblRules.setEnabled(enablement);
        this.btnAdd.setEnabled(enablement);
        this.btnDel.setEnabled(enablement);
        this.log.log("configSectionGetParentSection() end");
        return panel;
    }

    void loadCategories(Combo cmb) {
        TorrentAttribute ta = this.pi.getTorrentManager().getAttribute("Category");
        cmb.removeAll();
        cmb.setItems(ta.getDefinedValues());
    }

    void loadFields(Combo cmb) {
        List<TorrentFieldType> fields = TorrentFieldType.getSupportedFields();
        String[] flist = new String[fields.size()];
        for (int i = 0; i < flist.length; ++i) {
            flist[i] = fields.get(i).getName();
        }
        cmb.removeAll();
        cmb.setItems(flist);
    }

    void loadRules(OrderedRuleSet set, Table t) {
        TableItem[] items = t.getItems();
        for (int i = 0; i < items.length; ++i) {
            items[i].dispose();
        }
        List<TorrentMatcher> rules = set.getRules();
        for (int i = 0; i < rules.size(); ++i) {
            TableItem ti = new TableItem(t, 0);
            ti.setText(0, i + "");
            TorrentMatcher rule = rules.get(i);
            ti.setText(1, rule.getTrigger());
            ti.setText(2, rule.getCategory());
            ti.setText(3, rule.getMatchField().toString());
            this.log.log("Added rule " + rule.getTrigger() + ":" + rule.getMatchField().toString() + "===>" + rule.getCategory());
        }
        t.setSelection(0);
    }

    public void ruleSetUpdated(AdvancedRuleSet rules) {
        this.loadRules(rules, this.tblRules);
    }

    private void createCategoryCombo(Composite parent) {
        GridData gridData13 = new GridData();
        this.cmbCategory = new Combo(parent, 0);
        gridData13.horizontalSpan = 5;
        gridData13.horizontalAlignment = 4;
        gridData13.verticalAlignment = 2;
        this.cmbCategory.setLayoutData((Object)gridData13);
        this.cmbCategory.setToolTipText(this.locale.getLocalisedMessageText("autocat.category.tooltip"));
        this.loadCategories(this.cmbCategory);
    }

    private void createControlPanel(Composite parent) {
        GridData gridData12 = new GridData();
        Composite cControls = new Composite(parent, 0);
        this.btnAdd = new Button(cControls, 0);
        this.btnDel = new Button(cControls, 0);
        cControls.setLayout((Layout)new RowLayout());
        cControls.setLayoutData((Object)gridData12);
        gridData12.horizontalAlignment = 4;
        gridData12.verticalAlignment = 2;
        gridData12.horizontalSpan = 6;
        this.btnAdd.setText(this.locale.getLocalisedMessageText("autocat.config.add"));
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Pattern.compile(ConfigUI.this.txtTrigger.getText());
                    if (ConfigUI.this.cmbCategory.getText().length() == 0 || ConfigUI.this.cmbField.getSelectionIndex() < 0) {
                        ConfigUI.this.log.log(ConfigUI.this.locale.getLocalisedMessageText("autocat.err.nocat"));
                    } else {
                        TorrentFieldType type = (TorrentFieldType)ConfigUI.this.getTypeMap().get(ConfigUI.this.cmbField.getItem(ConfigUI.this.cmbField.getSelectionIndex()));
                        ConfigUI.this.config.getRules().addRule(type, ConfigUI.this.txtTrigger.getText(), ConfigUI.this.cmbCategory.getText());
                    }
                }
                catch (PatternSyntaxException pse) {
                    ConfigUI.this.log.log(ConfigUI.this.locale.getLocalisedMessageText("autocat.err.badregex", new String[]{ConfigUI.this.txtTrigger.getText()}));
                }
                ConfigUI.this.loadCategories(ConfigUI.this.cmbCategory);
            }
        });
        this.btnDel.setText(this.locale.getLocalisedMessageText("autocat.config.remove"));
        this.btnDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConfigUI.this.txtTrigger.getText().length() > 0) {
                    for (int ruleIndex : ConfigUI.this.tblRules.getSelectionIndices()) {
                        ConfigUI.this.config.getRules().removeRule(ruleIndex);
                    }
                }
            }
        });
    }

    protected Map getTypeMap() {
        if (null == this.typeMap) {
            this.typeMap = new HashMap();
            List<TorrentFieldType> f = TorrentFieldType.getSupportedFields();
            for (TorrentFieldType field : f) {
                this.typeMap.put(field.toString(), field);
            }
        }
        return this.typeMap;
    }

    private void createFieldCombo(Composite parent) {
        GridData gridData1 = new GridData();
        this.cmbField = new Combo(parent, 8);
        gridData1.horizontalSpan = 5;
        gridData1.grabExcessHorizontalSpace = false;
        gridData1.horizontalAlignment = 4;
        this.cmbField.setLayoutData((Object)gridData1);
        this.cmbField.setToolTipText(this.locale.getLocalisedMessageText("autocat.config.field.tooltip"));
        this.loadFields(this.cmbField);
    }

    private void createTable(Composite parent) {
        GridData gridData2 = new GridData();
        this.tblRules = new Table(parent, 67584);
        TableColumn colRuleIndex = new TableColumn(this.tblRules, 0);
        TableColumn colTrigger = new TableColumn(this.tblRules, 0);
        TableColumn colCategory = new TableColumn(this.tblRules, 0);
        TableColumn colField = new TableColumn(this.tblRules, 0);
        colTrigger.setText(this.locale.getLocalisedMessageText("autocat.trigger"));
        colTrigger.setWidth(200);
        colCategory.setText(this.locale.getLocalisedMessageText("autocat.category"));
        colCategory.setWidth(200);
        colField.setText(this.locale.getLocalisedMessageText("autocat.config.field"));
        colField.setWidth(200);
        colRuleIndex.setResizable(false);
        gridData2.verticalSpan = 1;
        this.tblRules.setHeaderVisible(true);
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = true;
        gridData2.horizontalAlignment = 4;
        gridData2.verticalAlignment = 4;
        gridData2.horizontalSpan = 6;
        this.tblRules.setLayoutData((Object)gridData2);
        this.tblRules.setLinesVisible(true);
        this.loadRules(this.config.getRules(), this.tblRules);
        this.tblRules.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                e.doit = true;
                int i = ConfigUI.this.tblRules.getSelectionIndex();
                if (i >= 0) {
                    TableItem t = ConfigUI.this.tblRules.getItem(i);
                    ConfigUI.this.txtTrigger.setText(t.getText(1));
                    ConfigUI.this.cmbCategory.setText(t.getText(2));
                    ConfigUI.this.cmbField.select(ConfigUI.this.cmbField.indexOf(t.getText(3)));
                }
            }
        });
        this.tblRules.pack();
    }

    public void ruleSetUpdated(OrderedRuleSet set) {
        this.loadRules(set, this.tblRules);
    }

    public void configSectionDelete() {
        this.config.getRules().removeRuleSetListener(this);
        this.config.configSectionDelete();
    }

    public String configSectionGetName() {
        return this.config.configSectionGetName();
    }

    public String configSectionGetParentSection() {
        return this.config.configSectionGetParentSection();
    }

    public void configSectionSave() {
        this.config.configSectionSave();
    }
}

