/*
 * Decompiled with CFR 0.152.
 */
package com.aimedia.autocat2.matching;

import com.aimedia.autocat.AutoCatPlugin;
import com.aimedia.autocat2.matching.IRuleSetListener;
import com.aimedia.autocat2.matching.OrderedRuleSet;
import com.aimedia.autocat2.matching.TorrentFieldType;
import com.aimedia.autocat2.matching.TorrentMatcher;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.plugins.torrent.Torrent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedRuleSet
implements OrderedRuleSet {
    private final ArrayList<IRuleSetListener> listeners = new ArrayList();
    private final List<TorrentMatcher> rules = new ArrayList<TorrentMatcher>();
    private int[] ver;
    private static final String BASEMAP = "rules";
    private static final String CATEGORY = "category";
    private static final String ENABLED = "enabled";
    private static final String TRIGGER = "trigger";
    private static final String FIELD = "field";
    private static final String VERSION_MAJOR = "version";
    private static final String VERSION_MINOR = "minor_version";
    private static final String VERSION_SUB = "sub_version";

    public AdvancedRuleSet() {
        this.setVersion(1, 1, 0);
    }

    @Override
    public void addRule(TorrentFieldType type, String trigger, String category) {
        this.addRule(type, trigger, category, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRule(TorrentFieldType type, String trigger, String category, int index) {
        TorrentMatcher matcher = TorrentMatcher.createTorrentMatcher(type, trigger, category);
        List<TorrentMatcher> list = this.rules;
        synchronized (list) {
            if (index < 0) {
                this.rules.add(matcher);
            } else {
                this.rules.add(index, matcher);
            }
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeRule(String oldRuleTrigger, TorrentFieldType newType, String newTrigger, String newCategory) {
        List<TorrentMatcher> list = this.rules;
        synchronized (list) {
            int idx = this.findRule(oldRuleTrigger);
            if (idx < 0) {
                throw new IllegalArgumentException("The rule with trigger " + oldRuleTrigger + " does not exist");
            }
            TorrentMatcher oldMatcher = this.rules.remove(idx);
            TorrentMatcher newMatcher = TorrentMatcher.createTorrentMatcher(newType == null ? oldMatcher.getMatchField() : newType, newTrigger == null ? oldMatcher.getTrigger() : newTrigger, newCategory == null ? oldMatcher.getCategory() : newCategory);
            this.rules.add(idx, newMatcher);
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findRule(String trigger) {
        int found = -1;
        List<TorrentMatcher> list = this.rules;
        synchronized (list) {
            for (int i = 0; i < this.rules.size(); ++i) {
                if (!this.rules.get(i).getTrigger().equals(trigger)) continue;
                found = i;
                break;
            }
        }
        return found;
    }

    @Override
    public List<TorrentMatcher> getRules() {
        return this.rules;
    }

    public boolean load(File configFile) {
        boolean success = true;
        FileInputStream fin = null;
        if (configFile.exists()) {
            Properties ruleProperties = new Properties();
            try {
                fin = new FileInputStream(configFile);
                ruleProperties.load(fin);
                fin.close();
            }
            catch (Exception e) {
                success = false;
                AutoCatPlugin.getPlugin().getLog().log("Unable to load configuration", (Throwable)e);
            }
            this.rules.addAll(AdvancedRuleSet.createRulesetFromProperties(ruleProperties));
        } else {
            success = false;
        }
        if (success) {
            this.notifyListeners();
        }
        return success;
    }

    private void setVersion(int versionMajor, int versionMinor, int versionSub) {
        if (this.ver == null) {
            this.ver = new int[3];
        }
        this.ver[0] = versionMajor;
        this.ver[1] = versionMinor;
        this.ver[2] = versionSub;
    }

    public int getMajorVersion() {
        return this.ver[0];
    }

    public int getMinorVersion() {
        return this.ver[1];
    }

    public int getSubVersion() {
        return this.ver[2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRuleSetListener(IRuleSetListener listener) {
        ArrayList<IRuleSetListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
        AutoCatPlugin.getPlugin().getLog().log(AutoCatPlugin.getPlugin().getLocale().getLocalisedMessageText("autocat.info.listeningToRules", new String[]{listener.toString()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRuleSetListener(IRuleSetListener listener) {
        ArrayList<IRuleSetListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public String match(Torrent torrent) {
        AutoCatPlugin.getPlugin().getLog().log(AutoCatPlugin.getPlugin().getLocale().getLocalisedMessageText("autocat.info.startMatch", new String[]{torrent.getName()}));
        for (TorrentMatcher r : this.rules) {
            if (!r.match(torrent)) continue;
            AutoCatPlugin.getPlugin().getLog().log(AutoCatPlugin.getPlugin().getLocale().getLocalisedMessageText("autocat.info.ruleMatched", new String[]{r.getTrigger(), torrent.getName(), r.getCategory()}));
            return r.getCategory();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        ArrayList<IRuleSetListener> arrayList = this.listeners;
        synchronized (arrayList) {
            for (IRuleSetListener l : this.listeners) {
                l.ruleSetUpdated(this);
            }
        }
    }

    public boolean save(File configFile) {
        boolean success = true;
        Properties ruleProperties = new Properties();
        ruleProperties.setProperty("autocat.version.major", this.getMajorVersion() + "");
        ruleProperties.setProperty("autocat.version.minor", this.getMinorVersion() + "");
        ruleProperties.setProperty("autocat.version.patch", this.getSubVersion() + "");
        int position = 0;
        for (TorrentMatcher rule : this.rules) {
            String base = String.format("autocat.rule.%d.", position);
            ruleProperties.setProperty(base + "position", position + "");
            ruleProperties.setProperty(base + ENABLED, Boolean.toString(rule.isEnabled()));
            ruleProperties.setProperty(base + TRIGGER, rule.getTrigger());
            ruleProperties.setProperty(base + CATEGORY, rule.getCategory());
            ruleProperties.setProperty(base + FIELD, rule.getMatchField().getID() + "");
            ++position;
        }
        FileOutputStream fos = null;
        try {
            if (!configFile.canWrite()) {
                success = false;
            } else {
                fos = new FileOutputStream(configFile);
                ruleProperties.store(fos, "Saved properties on " + new Date().toString());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            success = false;
        }
        catch (IOException e) {
            e.printStackTrace();
            success = false;
        }
        return success;
    }

    @Override
    public void removeRule(int index) {
        this.rules.remove(index);
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapRulePositions(int rule1Position, int rule2Position) {
        if (rule1Position == rule2Position) {
            return;
        }
        List<TorrentMatcher> list = this.rules;
        synchronized (list) {
            TorrentMatcher rule1 = this.rules.remove(rule1Position);
            TorrentMatcher rule2 = this.rules.remove(rule2Position);
            if (rule1 == null || rule2 == null) {
                throw new IllegalArgumentException("Invalid rule specification");
            }
            this.rules.add(rule2Position, rule1);
            this.rules.add(rule1Position, rule2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transferSettings(File mapFile, File propertyFile) {
        ArrayList<TorrentMatcher> rules = new ArrayList<TorrentMatcher>();
        try {
            FileInputStream fin = new FileInputStream(mapFile);
            BufferedInputStream bin = new BufferedInputStream(fin);
            Map map = BDecoder.decode((BufferedInputStream)bin);
            Long vmaj = (Long)map.get(VERSION_MAJOR);
            Long vmin = (Long)map.get(VERSION_MINOR);
            Long vsub = (Long)map.get(VERSION_SUB);
            List ruleList = (List)map.get(BASEMAP);
            Iterator iter = ruleList.iterator();
            ArrayList<TorrentMatcher> arrayList = rules;
            synchronized (arrayList) {
                while (iter.hasNext()) {
                    Map rule = (Map)iter.next();
                    String ltrig = new String((byte[])rule.get(TRIGGER));
                    String lcat = new String((byte[])rule.get(CATEGORY));
                    Long ltype = (Long)rule.get(FIELD);
                    if (ltype == null) {
                        ltype = new Long(TorrentFieldType.FILE_NAME.getID());
                    }
                    boolean len = (Long)rule.get(ENABLED) != 0L;
                    TorrentMatcher nm = TorrentMatcher.createTorrentMatcher(TorrentFieldType.getById(ltype.intValue()), ltrig, lcat);
                    nm.setEnabled(len);
                    rules.add(nm);
                }
            }
            bin.close();
            fin.close();
            Properties ruleProperties = new Properties();
            ruleProperties.setProperty("autocat.version.major", vmaj + "");
            ruleProperties.setProperty("autocat.version.minor", vmin + "");
            ruleProperties.setProperty("autocat.version.patch", vsub + "");
            int ruleId = 0;
            for (TorrentMatcher rule : rules) {
                String base = String.format("autocat.rule.%d.", ruleId);
                ruleProperties.setProperty(base + "position", ruleId + "");
                ruleProperties.setProperty(base + ENABLED, Boolean.toString(rule.isEnabled()));
                ruleProperties.setProperty(base + TRIGGER, rule.getTrigger());
                ruleProperties.setProperty(base + CATEGORY, rule.getCategory());
                ruleProperties.setProperty(base + FIELD, rule.getMatchField().getID() + "");
                ++ruleId;
            }
            FileOutputStream out = new FileOutputStream(propertyFile);
            ruleProperties.store(out, "Written by 'transferSettings' on " + new Date().toString());
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            AutoCatPlugin.getPlugin().getLog().log("Unable to convert old configuration", (Throwable)e);
        }
    }

    private static Collection<TorrentMatcher> createRulesetFromProperties(Properties properties) {
        TreeMap<Integer, TorrentMatcher> newRules = new TreeMap<Integer, TorrentMatcher>();
        HashSet<Integer> ruleIds = new HashSet<Integer>();
        Pattern idPattern = Pattern.compile("autocat\\.rule\\.([0-9]*)\\.enabled");
        Enumeration<?> keyEnum = properties.propertyNames();
        while (keyEnum.hasMoreElements()) {
            String key = (String)keyEnum.nextElement();
            Matcher m = idPattern.matcher(key);
            if (!m.matches()) continue;
            ruleIds.add(Integer.valueOf(m.group(1)));
        }
        for (Integer ruleId : ruleIds) {
            String base = String.format("autocat.rule.%d.", ruleId);
            try {
                String value = null;
                value = properties.getProperty(base + "position");
                if (value == null) {
                    AutoCatPlugin.getPlugin().getLog().log("Error parsing rule " + ruleId + ": missing required property " + base + "position");
                }
                Integer position = Integer.valueOf(value);
                value = properties.getProperty(base + ENABLED);
                if (value == null) {
                    AutoCatPlugin.getPlugin().getLog().log("Error parsing rule " + ruleId + ": missing required property " + base + ENABLED);
                }
                boolean enabled = Boolean.valueOf(value);
                value = properties.getProperty(base + TRIGGER);
                if (value == null) {
                    AutoCatPlugin.getPlugin().getLog().log("Error parsing rule " + ruleId + ": missing required property " + base + TRIGGER);
                }
                String trigger = value;
                value = properties.getProperty(base + CATEGORY);
                if (value == null) {
                    AutoCatPlugin.getPlugin().getLog().log("Error parsing rule " + ruleId + ": missing required property " + base + CATEGORY);
                }
                String category = value;
                value = properties.getProperty(base + FIELD);
                if (value == null) {
                    AutoCatPlugin.getPlugin().getLog().log("Error parsing rule " + ruleId + ": missing required property " + base + FIELD);
                }
                TorrentFieldType type = TorrentFieldType.getById(Integer.parseInt(value));
                TorrentMatcher rule = TorrentMatcher.createTorrentMatcher(type, trigger, category);
                rule.setEnabled(enabled);
                newRules.put(position, rule);
            }
            catch (Exception e) {
                AutoCatPlugin.getPlugin().getLog().log("Error parsing rule " + ruleId, (Throwable)e);
            }
        }
        return Collections.unmodifiableCollection(newRules.values());
    }
}

