/*
 * Decompiled with CFR 0.152.
 */
package com.aimedia.autocat2.matching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TorrentFieldType {
    private static final int FILENAME_ID = 1;
    private static SortedMap<Integer, TorrentFieldType> inverseHash;
    private static final int TRACKERURL_ID = 0;
    public static final TorrentFieldType FILE_NAME;
    public static final TorrentFieldType TRACKER_URL;
    private final int id;
    private final String name;

    public static TorrentFieldType getById(int id) {
        TorrentFieldType ret;
        if (inverseHash == null) {
            inverseHash = new TreeMap<Integer, TorrentFieldType>();
        }
        if ((ret = (TorrentFieldType)inverseHash.get(new Integer(id))) == null) {
            throw new IllegalArgumentException(id + " is not a valid type ID");
        }
        return ret;
    }

    public static final List<TorrentFieldType> getSupportedFields() {
        if (inverseHash == null) {
            return Collections.emptyList();
        }
        Set<Integer> keys = inverseHash.keySet();
        ArrayList<TorrentFieldType> retList = new ArrayList<TorrentFieldType>();
        for (Integer key : keys) {
            retList.add((TorrentFieldType)inverseHash.get(key));
        }
        return retList;
    }

    private static void addHash(TorrentFieldType type) {
        if (inverseHash == null) {
            inverseHash = new TreeMap<Integer, TorrentFieldType>();
        }
        inverseHash.put(new Integer(type.id), type);
    }

    private TorrentFieldType(String name, int id) {
        this.name = name;
        this.id = id;
        TorrentFieldType.addHash(this);
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static {
        FILE_NAME = new TorrentFieldType("Filename", 1);
        TRACKER_URL = new TorrentFieldType("Tracker URL", 0);
    }
}

