/*
 * Decompiled with CFR 0.152.
 */
package com.aimedia.autocat2.matching;

import com.aimedia.autocat2.matching.FileNameMatcher;
import com.aimedia.autocat2.matching.IMatcher;
import com.aimedia.autocat2.matching.IMatcherListener;
import com.aimedia.autocat2.matching.IMatcherObservable;
import com.aimedia.autocat2.matching.TorrentFieldType;
import com.aimedia.autocat2.matching.TrackerURLMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.gudy.azureus2.plugins.torrent.Torrent;

public abstract class TorrentMatcher
implements IMatcher,
IMatcherObservable {
    private String category;
    private List listenerList;
    private final TorrentFieldType matchField;
    private String triggerExpression;
    private Pattern triggerPattern;
    private boolean enabled;

    public static TorrentMatcher createTorrentMatcher(TorrentFieldType type, String triggerText, String category) {
        if (type == TorrentFieldType.FILE_NAME || type == null) {
            return new FileNameMatcher(triggerText, category);
        }
        if (type == TorrentFieldType.TRACKER_URL) {
            return new TrackerURLMatcher(triggerText, category);
        }
        throw new IllegalArgumentException("This is not a valid type of field");
    }

    protected TorrentMatcher(TorrentFieldType type, String trigger, String category) {
        this.matchField = type;
        this.triggerExpression = trigger;
        this.category = category;
        this.triggerPattern = trigger.startsWith("/") && trigger.endsWith("/") ? Pattern.compile(trigger.substring(1, trigger.length() - 1), 2) : Pattern.compile(trigger, 2);
    }

    public void addMatcherListener(IMatcherListener listener) {
        this.getListenerList().add(listener);
    }

    public String getCategory() {
        return this.category;
    }

    public TorrentFieldType getMatchField() {
        return this.matchField;
    }

    public String getTrigger() {
        return this.triggerExpression;
    }

    public void removeMatcherListener(IMatcherListener listener) {
        this.getListenerList().remove(listener);
    }

    private List getListenerList() {
        if (null == this.listenerList) {
            this.listenerList = new ArrayList();
        }
        return this.listenerList;
    }

    protected Pattern getTriggerPattern() {
        return this.triggerPattern;
    }

    protected void notifyListeners() {
        this.notifyListeners(null);
    }

    protected void notifyListeners(Object message) {
        for (IMatcherListener listener : this.getListenerList()) {
            listener.matcherUpdated(this, message);
        }
    }

    protected void setTriggerPattern(Pattern triggerPattern) {
        this.triggerPattern = triggerPattern;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enablement) {
        this.enabled = enablement;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setTrigger(String triggerExpression) {
        this.triggerExpression = triggerExpression;
    }

    public String toString() {
        return this.matchField + ": " + this.triggerExpression + " => " + this.category;
    }

    public abstract boolean match(Torrent var1);
}

